import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:get/get_state_manager/src/simple/get_state.dart';
import 'package:viser_remit/core/helper/shared_preference_helper.dart';
import 'package:viser_remit/data/services/api_client.dart';

import '../../../../core/route/route.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import '../../../../data/controller/onboard/onboard_controller.dart';

class BottomSection extends StatelessWidget {
  final int index;
  const BottomSection({super.key, required this.index});

  @override
  Widget build(BuildContext context) {
    return GetBuilder<OnboardController>(
      builder: (controller) => Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          TextButton(
            onPressed: () {
              controller.pageController.jumpToPage(controller.onboardImageList.length - 1);
            },
            child: Text(MyStrings.skip.tr, style: mediumLarge.copyWith(color: MyColor.colorWhite)),
          ),
          Row(
              mainAxisSize: MainAxisSize.min,
              children: List.generate(
                  controller.onboardImageList.length,
                  (index) => Container(
                        margin: const EdgeInsetsDirectional.only(end: 8),
                        width: controller.currentIndex == index ? 24 : 14,
                        height: 8,
                        decoration: BoxDecoration(color: controller.currentIndex == index ? MyColor.primaryColor : MyColor.colorWhite, borderRadius: BorderRadius.circular(100)),
                      ))),
          TextButton(
            onPressed: () {
              if (controller.onboardImageList.length - 1 == index) {
                Get.find<ApiClient>().sharedPreferences.setBool(SharedPreferenceHelper.appOpeningStatus, true);
                Get.offAllNamed(RouteHelper.loginScreen);
              } else {
                controller.pageController.nextPage(duration: const Duration(milliseconds: 1), curve: Curves.easeInSine);
              }
            },
            child: Text(
              controller.onboardImageList.length - 1 == index ? MyStrings.finish.tr : MyStrings.next.tr,
              style: mediumLarge.copyWith(color: MyColor.colorWhite),
            ),
          ),
        ],
      ),
    );
  }
}
